<?php
require_once 'src/Credenciais.php';
require_once 'src/SicoobToken.php';
require_once 'src/SicoobMovimentacaoArquivo.php';

$sicoobToken = new SicoobToken($clientId, $certificatePath, $privateKeyPath, $certificateKeyPassword);
$token = $sicoobToken->getToken();

$codigoSolicitacao = 31712575;
$idArquivo = 13253128;

$movimentacaoArquivo = new SicoobMovimentacaoArquivo($clientId, $certificatePath, $privateKeyPath, $certificateKeyPassword, $token);
$resultado = $movimentacaoArquivo->baixarArquivoMovimentacao($numeroContrato, $codigoSolicitacao, $idArquivo);

print_r($resultado);


$diretorioDestino = '/var/www/html/mydev/sicoob1/SicoobMovimentacao/';
$arquivoDecodificado = base64_decode($resultado['arquivo']);
$nomeArquivo = $resultado['nomeArquivo'];
$caminhoCompleto = $diretorioDestino . $nomeArquivo;

if (file_put_contents($caminhoCompleto, $arquivoDecodificado) !== false) {
    echo "Arquivo salvo com sucesso: $nomeArquivo<br>";

    $zip = new ZipArchive;
    if ($zip->open($caminhoCompleto) === TRUE) {
        $zip->extractTo($diretorioDestino);
        $zip->close();
        echo "Arquivo descompactado com sucesso!<br>";

        $jsonFile = str_replace('.zip', '.json', $nomeArquivo);
        $caminhoJson = $diretorioDestino . $jsonFile;

        if (file_exists($caminhoJson)) {
            $jsonData = file_get_contents($caminhoJson);
            $registros = json_decode($jsonData, true);

            if ($registros === null) {
                echo "Erro ao decodificar o JSON.<br>";
            } else {
		echo "<table border='1'>";
		echo "<tr><th>Numero Titulo</th><th>Data Liquidacao</th><th>Data Previsao Credito</th><th>Valor Titulo</th><th>Valor Liquido</th></tr>";

		foreach ($registros as $registro) {
		    $numeroTitulo = isset($registro['numeroTitulo']) ? $registro['numeroTitulo'] : 'N/A';
		    
		    $dataLiquidacao = isset($registro['dataLiquidacao']) ? (new DateTime($registro['dataLiquidacao']))->format('d/m/Y') : 'N/A';
		    $dataPrevisaoCredito = isset($registro['dataPrevisaoCredito']) ? (new DateTime($registro['dataPrevisaoCredito']))->format('d/m/Y') : 'N/A';
		    
		    $valorTitulo = isset($registro['valorTitulo']) ? number_format($registro['valorTitulo'], 2, ',', '.') : 'N/A';
		    $valorLiquido = isset($registro['valorLiquido']) ? number_format($registro['valorLiquido'], 2, ',', '.') : 'N/A';

		    echo "<tr>
			    <td>$numeroTitulo</td>
			    <td>$dataLiquidacao</td>
			    <td>$dataPrevisaoCredito</td>
			    <td>R$ $valorTitulo</td>
			    <td>R$ $valorLiquido</td>
			  </tr>";
		}
		echo "</table>";
            }
        } else {
            echo "Arquivo JSON não encontrado após descompactação.<br>";
        }
    } else {
        echo "Erro ao abrir o arquivo ZIP.<br>";
    }
} else {
    echo "Erro ao salvar o arquivo.<br>";
}

?>



