<?php

class SicoobVencimento
{
    private $clientId;
    private $certificatePath;
    private $privateKeyPath;
    private $certificateKeyPassword;
    private $token;
    private $apiUrl = 'https://api.sicoob.com.br/cobranca-bancaria/v2/boletos/prorrogacoes/data-vencimento';

    public function __construct($clientId, $certificatePath, $privateKeyPath, $certificateKeyPassword, $token)
    {
        $this->clientId = $clientId;
        $this->certificatePath = $certificatePath;
        $this->privateKeyPath = $privateKeyPath;
        $this->certificateKeyPassword = $certificateKeyPassword;
        $this->token = $token;
    }

    public function prorrogarVencimento($numeroContrato, $nossoNumero, $dataVencimento)
    {
        $data = [
            [
                "numeroContrato" => $numeroContrato,
                "modalidade" => 1, // Modalidade geralmente é 1 (Cobrança Simples)
                "nossoNumero" => $nossoNumero,
                "dataVencimento" => $dataVencimento
            ]
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->apiUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PATCH');
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_SSLCERT, $this->certificatePath);
        curl_setopt($ch, CURLOPT_SSLKEY, $this->privateKeyPath);
        curl_setopt($ch, CURLOPT_SSLCERTPASSWD, $this->certificateKeyPassword);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'client_id: ' . $this->clientId,
            'Authorization: Bearer ' . $this->token,
            'Accept: application/json'
        ]);
        $response = curl_exec($ch);

        if (curl_errno($ch)) {
            echo 'Erro cURL: ' . curl_error($ch);
            curl_close($ch);
            return null;
        }

        curl_close($ch);

        $responseData = json_decode($response, true);

        if (isset($responseData['resultado'])) {
            return $responseData['resultado'];
        } else {
            return "Erro ao prorrogar vencimento: " . $response;
        }
    }
}

