<?php

class SicoobMovimentacao
{
    private $clientId;
    private $certificatePath;
    private $privateKeyPath;
    private $certificateKeyPassword;
    private $token;
    private $apiUrl = 'https://api.sicoob.com.br/cobranca-bancaria/v2/boletos/solicitacoes/movimentacao';

    public function __construct($clientId, $certificatePath, $privateKeyPath, $certificateKeyPassword, $token)
    {
        $this->clientId = $clientId;
        $this->certificatePath = $certificatePath;
        $this->privateKeyPath = $privateKeyPath;
        $this->certificateKeyPassword = $certificateKeyPassword;
        $this->token = $token;
    }

    public function solicitarMovimentacao($numeroContrato, $tipoMovimento, $dataInicial, $dataFinal)
    {
        $data = [
            "numeroContrato" => $numeroContrato,
            "tipoMovimento" => $tipoMovimento,
            "dataInicial" => $dataInicial,
            "dataFinal" => $dataFinal
        ];

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $this->apiUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data)); // Enviando o JSON
        curl_setopt($ch, CURLOPT_SSLCERT, $this->certificatePath);
        curl_setopt($ch, CURLOPT_SSLKEY, $this->privateKeyPath);
        curl_setopt($ch, CURLOPT_SSLCERTPASSWD, $this->certificateKeyPassword);

        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'client_id: ' . $this->clientId,
            'Authorization: Bearer ' . $this->token,
            'Accept: application/json'
        ]);

        $response = curl_exec($ch);

        if (curl_errno($ch)) {
            echo 'Erro cURL: ' . curl_error($ch);
            curl_close($ch);
            return null;
        }

        curl_close($ch);

        $responseData = json_decode($response, true);

        if (isset($responseData['resultado']['codigoSolicitacao'])) {
            return $responseData['resultado'];
        } else {
            return "Erro ao solicitar a movimentação: " . $response;
        }
    }
}

